/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import cds.astro.Region;

public class ConvexRegion
extends Region {
    boolean direct;
    int nvert = 0;
    Coo[] vert;
    double[][] vecs;
    double dim1 = 0.0;
    double dim2 = 0.0;
    double pa = 0.0;

    ConvexRegion(Coo[] cooArray) {
        int n;
        if (cooArray.length < 3) {
            System.err.println("#+++Convex(" + cooArray.length + "points) requires at least 3 points!");
            return;
        }
        this.nvert = cooArray.length;
        this.vert = new Coo[this.nvert + 1];
        this.centroid = new Coo();
        for (n = 0; n < this.nvert; ++n) {
            if (cooArray[n].x == 0.0 && cooArray[n].y == 0.0 && cooArray[n].x == 0.0) {
                System.err.println("#+++Convex(" + cooArray.length + "points) has invalid point#" + n);
                this.nvert = 0;
                return;
            }
            this.vert[n] = cooArray[n];
            this.centroid.x += cooArray[n].x;
            this.centroid.y += cooArray[n].y;
            this.centroid.z += cooArray[n].z;
        }
        this.vert[this.nvert] = this.vert[0];
        this.centroid.normalize();
        this.vecs = new double[this.nvert][3];
        for (n = 0; n < this.nvert; ++n) {
            this.vert[n].vecprod(this.vert[n + 1], this.vecs[n]);
            Coo.normalize(this.vecs[n]);
        }
        this.minrad = 100.0;
        this.maxrad = 0.0;
        for (n = 0; n < this.nvert; ++n) {
            double d = this.centroid.dotprod(this.vecs[n]);
            if (n == 0) {
                this.direct = d >= 0.0;
            } else if (d > 0.0 ^ this.direct) {
                System.err.println("#+++Convex(" + cooArray.length + "points) not convex at point#" + n + "=" + this.vert[n] + "; direct=" + this.direct + ", d=" + d);
                this.nvert = 0;
                return;
            }
            d = Math.abs(AstroMath.asind(d));
            if (d < this.minrad) {
                this.minrad = d;
            }
            if (d > this.maxrad) {
                this.maxrad = d;
            }
            if ((d = this.centroid.distance(this.vert[n])) < this.minrad) {
                this.minrad = d;
            }
            if (!(d > this.maxrad)) continue;
            this.maxrad = d;
        }
        if (DEBUG) {
            System.out.println("#...Created: " + this.toString() + " dist=" + this.minrad + "/" + this.maxrad);
        }
    }

    final void setBox(double d, double d2, double d3) {
        if (this.nvert != 4 || d <= 0.0 || d2 <= 0.0) {
            System.err.println("#***setBox(" + d + "," + d2 + "," + d3 + ") -- not a box:");
            System.err.println("#   " + this);
            return;
        }
        if (d < d2) {
            this.dim1 = d2;
            this.dim2 = d;
            this.pa = d3 + 90.0;
        } else {
            this.dim1 = d;
            this.dim2 = d2;
            this.pa = d3;
        }
        while (this.pa < 0.0) {
            this.pa += 180.0;
        }
        while (this.pa >= 180.0) {
            this.pa -= 180.0;
        }
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nvert < 3) {
            stringBuffer.append("*INVALID*");
        }
        if (this.dim1 > 0.0) {
            stringBuffer.append("Box(" + this.centroid);
            stringBuffer.append(", " + this.dim1 + "x" + this.dim2);
            if (this.pa >= 0.0) {
                stringBuffer.append(", pa=" + this.pa);
            }
        } else {
            stringBuffer.append("Convex[");
            stringBuffer.append(this.nvert);
            stringBuffer.append("]");
            String string = "(";
            for (int i = 0; i < this.nvert; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(this.vert[i].toString());
                string = ", ";
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public double area() {
        if (this.nvert < 3) {
            return Double.NaN;
        }
        double d = (double)(2 - this.nvert) * 180.0;
        d += this.vert[0].angle(this.vert[this.nvert - 1], this.vert[1]);
        for (int i = 1; i < this.nvert; ++i) {
            d += this.vert[i].angle(this.vert[i - 1], this.vert[i + 1]);
        }
        return 57.29577951308232 * d;
    }

    @Override
    public boolean checkCoo(Coo coo) {
        if (this.nvert < 3) {
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Convex.checkCoo(" + coo + ")");
        }
        for (int i = 0; i < this.nvert; ++i) {
            double d = coo.dotprod(this.vecs[i]);
            if (!(d > 0.0 ^ this.direct)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int checkCircle(Coo coo, double d) {
        int n;
        if (this.centroid == null) {
            return 0;
        }
        if (DEBUG) {
            System.out.println("#...Convex.checkCircle(" + coo + ", r=" + d + ")");
        }
        if ((n = this.check1(coo, d)) != 1) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        double d2 = 2.0 * AstroMath.sind(d / 2.0);
        d2 *= d2;
        double d3 = AstroMath.sind(d);
        for (int i = 0; i < this.nvert; ++i) {
            double d4;
            double d5;
            double d6;
            double d7 = coo.dist2(this.vert[i]);
            if (d7 < d2) {
                ++n2;
                if (n3 > 0) {
                    return 1;
                }
            }
            if (d7 > d2) {
                ++n3;
                if (n2 > 0) {
                    return 1;
                }
            }
            if (((d6 = this.vert[i].dotprod(this.vert[i + 1])) * (d5 = coo.dotprod(this.vert[i])) - (d4 = coo.dotprod(this.vert[i + 1]))) * (d6 * d4 - d5) <= 0.0 || !(Math.abs(coo.dotprod(this.vecs[i])) < d3)) continue;
            return 1;
        }
        if (DEBUG) {
            System.out.print("    nin=" + n2 + ", nut=" + n3);
        }
        if (n2 > 0) {
            return 3;
        }
        return this.checkCoo(coo) ? -1 : 0;
    }

    @Override
    public int checkQbox(int n) {
        int n2;
        if (this.centroid == null) {
            return 0;
        }
        Qbox qbox = new Qbox();
        qbox.set(n);
        Coocube coocube = qbox.center();
        double d = qbox.radius();
        int n3 = this.checkCircle(coocube, d);
        if (n3 != 1) {
            if (DEBUG) {
                System.out.println("#-->" + n3);
            }
            return n3;
        }
        if (DEBUG) {
            System.out.print("#...convex next");
        }
        double[][] dArray = new double[5][3];
        Qbox.ucorners(qbox.qbox, dArray);
        dArray[4][0] = dArray[0][0];
        dArray[4][1] = dArray[0][1];
        dArray[4][2] = dArray[0][2];
        double[][] dArray2 = new double[4][3];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[3];
        for (n2 = 0; n2 < 4; ++n2) {
            Coo.vecprod(dArray[n2], dArray[n2 + 1], dArray2[n2]);
            Coo.normalize(dArray2[n2]);
            dArray3[n2] = Coo.dotprod(dArray[n2], dArray[n2 + 1]);
        }
        for (n2 = 0; n2 < this.nvert; ++n2) {
            double d2 = this.vert[n2].dotprod(this.vert[n2 + 1]);
            for (int i = 0; i < 4; ++i) {
                if (DEBUG) {
                    System.out.print(" (" + n2 + "," + i + ")");
                }
                Coo.vecprod(this.vecs[n2], dArray2[i], dArray4);
                Coo.normalize(dArray4);
                if (this.vert[n2].dotprod(dArray4) < d2) {
                    if (DEBUG) {
                        System.out.print(" (-)");
                    }
                    dArray4[0] = -dArray4[0];
                    dArray4[1] = -dArray4[1];
                    dArray4[2] = -dArray4[2];
                }
                if (!(this.vert[n2].dotprod(dArray4) > d2) || !(this.vert[n2 + 1].dotprod(dArray4) > d2) || !(Coo.dotprod(dArray[i], dArray4) > dArray3[i]) || !(Coo.dotprod(dArray[i + 1], dArray4) > dArray3[i])) continue;
                if (DEBUG) {
                    System.out.println("");
                }
                return 1;
            }
        }
        if (DEBUG) {
            System.out.println(" (no intersection)");
        }
        if (this.checkCoo(coocube)) {
            return -1;
        }
        return 0;
    }
}

